<?php

namespace Config;

$routes = Services::routes();

/*
 * ============================================================================
 * SATISAHAZIR.COM - TAM GÜVENLİ JWT SİSTEMİ v2.0
 * ============================================================================
 * 
 * ⚠️ TÜM ESKİ ENDPOINT'LER KAPATILDI!
 * 
 * Eski: /wp-json/wdk/v1/*  → 410 Gone
 * Yeni: /api/v1/*          → JWT korumalı
 * 
 * Mevcut controller metodları KORUNDU, sadece route'lar ve auth değişti.
 * Tüm controller'lar JWTAuthTrait kullanacak şekilde güncellenecek.
 * 
 * @version    2.0.0
 * ============================================================================
 */

$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);

// 404 Handler - JSON response
$routes->set404Override(function() {
    return Services::response()
        ->setStatusCode(404)
        ->setJSON([
            'code' => 'not_found',
            'message' => 'Endpoint bulunamadı. Lütfen /api/v1/* kullanın.',
            'documentation' => '/api/v1/docs'
        ]);
});

/*
 * ============================================================================
 * ANA SAYFA & WEB ROUTES
 * ============================================================================
 */
$routes->get('/', 'Home::index');
$routes->get('/verify-email', 'User::verify_email');

/*
 * ============================================================================
 * ESKİ ENDPOINT'LER - TAMAMEN KAPATILDI (410 Gone)
 * ============================================================================
 * Tüm eski wp-json endpoint'leri 410 Gone döner
 * Güvenlik açığı oluşturmaması için hiçbir eski endpoint çalışmaz
 */

$routes->group('wp-json', function($routes) {
    // Tüm alt path'leri yakala
    $routes->get('(:any)', 'Api\V1\LegacyController::deprecated');
    $routes->post('(:any)', 'Api\V1\LegacyController::deprecated');
    $routes->put('(:any)', 'Api\V1\LegacyController::deprecated');
    $routes->delete('(:any)', 'Api\V1\LegacyController::deprecated');
    $routes->options('(:any)', 'Api\V1\LegacyController::deprecated');
});

$routes->get('wp-login.php', 'Api\V1\LegacyController::deprecated');

/*
 * ============================================================================
 * API v1 - PUBLIC ENDPOINTS (Token gerektirmez)
 * ============================================================================
 */

$routes->group('api/v1', ['namespace' => 'App\Controllers'], function($routes) {
    
    // =========================================================================
    // HEALTH CHECK & DOCS
    // =========================================================================
    $routes->get('health', 'Api\V1\HealthController::index');
    $routes->get('docs', 'Api\V1\DocsController::index');
    
    // =========================================================================
    // AUTH - PUBLIC (Token gerektirmez)
    // =========================================================================
    $routes->post('auth/login', 'User::login');
    $routes->post('auth/register', 'User::register');
    $routes->post('auth/social-login', 'User::auth_register');
    $routes->post('auth/refresh', 'User::refresh_token');
    
    // Email Verification
    $routes->post('auth/verify-email', 'User::verify_email_code');
    $routes->post('auth/resend-verification', 'User::send_verification_email');
    $routes->get('auth/verify-email', 'User::verify_email');
    
    // Password Reset
    $routes->post('auth/forgot-password', 'User::send_password_reset_code');
    $routes->post('auth/verify-reset-code', 'User::verify_password_reset_code');
    $routes->post('auth/reset-password', 'User::reset_password_with_code');
    
    // =========================================================================
    // PUBLIC DATA (Token gerektirmez)
    // =========================================================================
    
    // Listings - Public
    $routes->get('listings', 'Listings::listings');
    $routes->get('listings/(:num)', 'Listings::listing_detail/$1');
    $routes->get('listings/search', 'Listings::listings');
    
    // Categories & Locations
    $routes->get('categories', 'Listings::categories');
    $routes->get('locations', 'Listings::locations');
    $routes->get('locations/all', 'Listings::getAllForSearch');
    $routes->get('provinces', 'Listings::provinces');
    $routes->get('districts', 'Listings::districts');
    $routes->get('neighborhoods', 'Listings::neighborhoods');
    $routes->get('locations/hierarchy', 'Listings::locations_hierarchy');
    
    // Other Public Data
    $routes->get('fields', 'Listings::fields');
    $routes->get('agents', 'Listings::agents');
    $routes->get('home', 'Listings::home');
    
    // Device Registration (anonim)
    $routes->post('device/register', 'User::registerDevice');
    
    // Mobile Config
    $routes->get('mobile/config', 'MobileController::getAppConfig');
    $routes->get('mobile/features', 'MobileController::getFeatureFlags');
    $routes->get('mobile/version', 'MobileController::checkVersion');
});

/*
 * ============================================================================
 * API v1 - PROTECTED ENDPOINTS (JWT Token zorunlu)
 * ============================================================================
 */

$routes->group('api/v1', ['namespace' => 'App\Controllers', 'filter' => 'jwt'], function($routes) {
    
    // =========================================================================
    // AUTH - PROTECTED
    // =========================================================================
    $routes->get('auth/me', 'User::user');
    $routes->post('auth/logout', 'User::logout');
    $routes->post('auth/logout-all', 'User::logout_all');
    $routes->get('auth/sessions', 'User::get_sessions');
    $routes->delete('auth/sessions/(:num)', 'User::terminate_session/$1');
    $routes->post('auth/change-password', 'User::change_password');
    
    // =========================================================================
    // USER PROFILE
    // =========================================================================
    $routes->get('user', 'User::user');
    $routes->post('user', 'User::edit_user');
    $routes->put('user', 'User::edit_user');
    $routes->delete('user', 'User::delete');
    $routes->get('user/statistics', 'User::user_statistics');
    $routes->get('user/consents', 'User::get_consents');
    
    // =========================================================================
    // MY LISTINGS
    // =========================================================================
    $routes->get('my-listings', 'Mylistings::mylistings');
    $routes->post('my-listings', 'Mylistings::edit_listing');
    $routes->get('my-listings/(:num)', 'Mylistings::get_listing/$1');
    $routes->put('my-listings/(:num)', 'Mylistings::edit_listing/$1');
    $routes->delete('my-listings/(:num)', 'Mylistings::delete/$1');
    
    // Listing Images
    $routes->post('my-listings/(:num)/images', 'Mylistings::images_upload/$1');
    $routes->delete('my-listings/(:num)/images/(:num)', 'Mylistings::delete_image/$1/$2');
    $routes->post('my-listings/(:num)/images/reorder', 'Mylistings::move_image_top/$1');
    
    // =========================================================================
    // FAVORITES
    // =========================================================================
    $routes->get('favorites', 'Listings::get_favorites');
    $routes->post('favorites', 'Listings::listing_favorite');
    $routes->post('favorites/toggle', 'Listings::listing_favorite');
    $routes->delete('favorites/(:num)', 'Listings::remove_favorite/$1');
    
    // =========================================================================
    // HIDDEN LISTINGS
    // =========================================================================
    $routes->get('hidden', 'Listings::get_hidden');
    $routes->post('hidden', 'Listings::listing_hidden');
    $routes->post('hidden/toggle', 'Listings::listing_hidden');
    $routes->delete('hidden/(:num)', 'Listings::remove_hidden/$1');
    
    // =========================================================================
    // ENQUIRIES (Mesajlar)
    // =========================================================================
    $routes->get('enquiries', 'EnquireController::getMyEnquiries');
    $routes->get('enquiries/(:num)', 'EnquireController::getEnquiryDetails/$1');
    $routes->post('enquiries', 'EnquireController::listing_agent_message');
    $routes->post('enquiries/(:num)/reply', 'EnquireController::sendUserReply/$1');
    $routes->post('enquiries/(:num)/read', 'EnquireController::markEnquiryAsRead/$1');
    $routes->get('enquiries/unread-count', 'EnquireController::getUnreadCount');
    
    // =========================================================================
    // SEARCH REQUESTS (Mülk arama talepleri)
    // =========================================================================
    $routes->get('search-requests', 'SearchRequestController::getMyRequests');
    $routes->get('search-requests/(:num)', 'SearchRequestController::getRequestDetails/$1');
    $routes->post('search-requests', 'SearchRequestController::propertySearchRequest');
    $routes->post('search-requests/(:num)/reply', 'SearchRequestController::addReply/$1');
    $routes->put('search-requests/(:num)/criteria', 'SearchRequestController::updateCriteria/$1');
    $routes->get('search-requests/unread-count', 'SearchRequestController::getUnreadCount');
    
    // =========================================================================
    // NOTIFICATIONS
    // =========================================================================
    $routes->get('notifications', 'NotificationController::getUserNotifications');
    $routes->get('notifications/unread-count', 'NotificationController::getUnreadCount');
    $routes->post('notifications/(:num)/read', 'NotificationController::mark_read/$1');
    $routes->post('notifications/read-all', 'NotificationController::mark_all_read');
    $routes->delete('notifications/(:num)', 'NotificationController::deleteNotification/$1');
    $routes->get('notifications/settings', 'NotificationController::getSettings');
    $routes->put('notifications/settings', 'NotificationController::updateSettings');
    
    // =========================================================================
    // DEVICES
    // =========================================================================
    $routes->get('devices', 'DeviceController::get_user_devices');
    $routes->put('devices/(:segment)', 'DeviceController::update_device_info/$1');
    $routes->post('devices/push-token', 'DeviceController::update_push_token');
    $routes->post('devices/(:segment)/status', 'DeviceController::update_device_status/$1');
    $routes->post('devices/topics', 'DeviceController::update_topic_subscriptions');
    $routes->delete('devices/(:segment)', 'DeviceController::remove_device/$1');
    
    // =========================================================================
    // CONSENTS (KVKK/GDPR)
    // =========================================================================
    $routes->get('consents', 'ConsentController::getConsents');
    $routes->post('consents', 'ConsentController::saveConsents');
    $routes->put('consents', 'ConsentController::updateSingleConsent');
    $routes->get('consents/history', 'ConsentController::getConsentHistory');
    $routes->post('consents/check-versions', 'ConsentController::checkConsentVersions');
    $routes->post('consents/transfer', 'ConsentController::transferConsents');
    
    // =========================================================================
    // GDPR
    // =========================================================================
    $routes->post('gdpr/export', 'GdprController::requestDataExport');
    $routes->get('gdpr/export-status', 'GdprController::getExportStatus');
    $routes->get('gdpr/download', 'GdprController::downloadExport');
    $routes->post('gdpr/delete', 'GdprController::requestDataDeletion');
    $routes->get('gdpr/deletion-status', 'GdprController::getDeletionStatus');
    $routes->post('gdpr/forget-me', 'ForgetMeController::forgetMe');
    
    // =========================================================================
    // ANALYTICS
    // =========================================================================
    $routes->post('analytics/view', 'AnalyticsController::recordView');
    $routes->post('analytics/view-duration', 'AnalyticsController::updateViewDuration');
    $routes->post('analytics/search', 'AnalyticsController::recordSearch');
    $routes->post('analytics/app-open', 'AnalyticsController::recordAppOpen');
    $routes->get('analytics/my-stats', 'AnalyticsController::getUserStats');
    $routes->get('analytics/search-history', 'AnalyticsController::getUserSearchHistory');
    
    // Saved Searches
    $routes->get('saved-searches', 'AnalyticsController::getUserSearches');
    $routes->post('saved-searches', 'AnalyticsController::saveSearch');
    $routes->delete('saved-searches/(:num)', 'AnalyticsController::deleteSearch/$1');
    $routes->post('saved-searches/(:num)/notification', 'AnalyticsController::toggleSearchNotification/$1');
    
    // =========================================================================
    // MOBILE
    // =========================================================================
    $routes->post('mobile/feedback', 'MobileController::submitFeedback');
    $routes->post('mobile/crash-report', 'MobileController::submitCrashReport');
    $routes->post('mobile/emergency-notification', 'MobileController::sendEmergencyNotification');
});

/*
 * ============================================================================
 * API v1 - AGENT ENDPOINTS (JWT + Agent yetkisi)
 * ============================================================================
 */

$routes->group('api/v1/agent', ['namespace' => 'App\Controllers', 'filter' => 'jwt,jwt-agent'], function($routes) {
    
    // Dashboard
    $routes->get('dashboard', 'Agent\Dashboard::index');
    $routes->get('stats', 'Agent\Dashboard::stats');
    
    // Enquiries
    $routes->get('enquiries', 'EnquireController::getEnquiries');
    $routes->get('enquiries/(:num)', 'EnquireController::getEnquiryDetails/$1');
    $routes->post('enquiries/(:num)/reply', 'EnquireController::addReply/$1');
    $routes->post('enquiries/(:num)/close', 'EnquireController::closeEnquiry/$1');
    $routes->post('enquiries/(:num)/reminder', 'EnquireController::sendCallReminder/$1');
    $routes->get('enquiries/upcoming', 'EnquireController::getUpcomingAppointments');
    $routes->get('enquiries/notification-info', 'EnquireController::getAgentNotificationInfo');
    
    // Search Requests
    $routes->get('search-requests', 'SearchRequestController::getSearchRequests');
    $routes->get('search-requests/(:num)', 'SearchRequestController::getRequestDetails/$1');
    $routes->post('search-requests/(:num)/reply', 'SearchRequestController::addReply/$1');
    $routes->post('search-requests/(:num)/complete', 'SearchRequestController::completeRequest/$1');
    $routes->put('search-requests/(:num)/criteria', 'SearchRequestController::updateCriteria/$1');
    $routes->get('search-requests/stats', 'SearchRequestController::getStats');
    $routes->get('search-requests/categories-count', 'SearchRequestController::getCategoriesCount');
    
    // Profile
    $routes->get('profile', 'Agent\Profile::index');
    $routes->put('profile', 'Agent\Profile::update');
    $routes->get('notifications/settings', 'Agent\Profile::notificationSettings');
    $routes->put('notifications/settings', 'Agent\Profile::updateNotificationSettings');
});

/*
 * ============================================================================
 * API v1 - ADMIN ENDPOINTS (JWT + Admin yetkisi)
 * ============================================================================
 */

$routes->group('api/v1/admin', ['namespace' => 'App\Controllers', 'filter' => 'jwt,jwt-admin'], function($routes) {
    
    // =========================================================================
    // DASHBOARD & STATS
    // =========================================================================
    $routes->get('dashboard', 'StatsController::dashboardStats');
    $routes->get('stats/overview', 'StatsController::performanceOverview');
    $routes->get('stats/enquiries', 'StatsController::enquiryStats');
    $routes->get('stats/enquiries/agent/(:num)', 'StatsController::agentEnquiryStats/$1');
    $routes->get('stats/search-requests', 'StatsController::searchRequestStats');
    $routes->get('stats/search-requests/agent/(:num)', 'StatsController::agentSearchRequestStats/$1');
    $routes->get('stats/agents', 'StatsController::agentPerformance');
    $routes->get('stats/trends/enquiries', 'StatsController::enquiryTrends');
    $routes->get('stats/trends/search-requests', 'StatsController::searchRequestTrends');
    $routes->get('stats/popular-criteria', 'StatsController::popularSearchCriteria');
    $routes->get('stats/conversion', 'StatsController::conversionRates');
    
    // =========================================================================
    // USERS
    // =========================================================================
    $routes->get('users', 'Admin\UsersAdmin::index');
    $routes->get('users/(:num)', 'Admin\UsersAdmin::view/$1');
    $routes->put('users/(:num)', 'Admin\UsersAdmin::update/$1');
    $routes->post('users/(:num)/type', 'Admin\UsersAdmin::changeUserType/$1');
    $routes->delete('users/(:num)', 'Admin\UsersAdmin::delete/$1');
    $routes->get('users/stats', 'Admin\UsersAdmin::stats');
    $routes->get('users/deleted', 'Admin\UsersAdmin::deleted');
    $routes->post('users/(:num)/restore', 'Admin\UsersAdmin::restore/$1');
    $routes->get('users/export', 'Admin\UsersAdmin::export');
    $routes->post('users/bulk', 'Admin\UsersAdmin::bulkAction');
    
    // =========================================================================
    // LISTINGS
    // =========================================================================
    $routes->get('listings', 'Admin\ListingsAdmin::index');
    $routes->get('listings/pending', 'Admin\ListingsAdmin::pending');
    $routes->post('listings/(:num)/approve', 'Admin\ListingsAdmin::approve/$1');
    $routes->post('listings/(:num)/reject', 'Admin\ListingsAdmin::reject/$1');
    $routes->delete('listings/(:num)', 'Admin\ListingsAdmin::delete/$1');
    
    // =========================================================================
    // ENQUIRIES
    // =========================================================================
    $routes->get('enquiries', 'Admin\EnquiriesAdmin::index');
    $routes->get('enquiries/(:num)', 'Admin\EnquiriesAdmin::view/$1');
    $routes->get('enquiries/stats', 'Admin\EnquiriesAdmin::stats');
    $routes->post('enquiries/bulk', 'Admin\EnquiriesAdmin::bulkAction');
    $routes->get('enquiries/customer/(:num)', 'EnquireController::getCustomerEnquiries/$1');
    $routes->get('enquiries/property/(:num)', 'EnquireController::getPropertyEnquiries/$1');
    $routes->post('enquiries/(:num)/note', 'EnquireController::addAdminNote/$1');
    $routes->post('enquiries/(:num)/notify-customer', 'EnquireController::sendCustomerReplyNotification/$1');
    
    // =========================================================================
    // SEARCH REQUESTS
    // =========================================================================
    $routes->get('search-requests', 'Admin\SearchRequestsAdmin::index');
    $routes->get('search-requests/(:num)', 'Admin\SearchRequestsAdmin::view/$1');
    $routes->get('search-requests/stats', 'Admin\SearchRequestsAdmin::stats');
    $routes->get('search-requests/dashboard', 'Admin\SearchRequestsAdmin::dashboard');
    $routes->post('search-requests/(:num)/assign', 'SearchRequestController::assignToAgent/$1');
    $routes->post('search-requests/bulk', 'Admin\SearchRequestsAdmin::bulkAction');
    $routes->post('search-requests/bulk-status', 'SearchRequestController::bulkUpdateStatus');
    $routes->get('search-requests/export', 'Admin\SearchRequestsAdmin::export');
    $routes->get('search-requests/criteria-analysis', 'Admin\SearchRequestsAdmin::criteriaAnalysis');
    $routes->get('search-requests/agent-performance', 'Admin\SearchRequestsAdmin::agentPerformance');
    
    // Assignment & Templates
    $routes->get('search-requests/assignment-rules', 'Admin\SearchRequestsAdmin::assignmentRules');
    $routes->put('search-requests/assignment-rules', 'Admin\SearchRequestsAdmin::updateAssignmentRules');
    $routes->get('search-requests/reply-templates', 'Admin\SearchRequestsAdmin::replyTemplates');
    $routes->post('search-requests/reply-templates', 'Admin\SearchRequestsAdmin::saveReplyTemplate');
    $routes->delete('search-requests/reply-templates/(:num)', 'Admin\SearchRequestsAdmin::deleteReplyTemplate/$1');
    $routes->get('search-requests/notification-settings', 'Admin\SearchRequestsAdmin::notificationSettings');
    $routes->put('search-requests/notification-settings', 'Admin\SearchRequestsAdmin::updateNotificationSettings');
    
    // =========================================================================
    // DEVICES
    // =========================================================================
    $routes->get('devices', 'Admin\DevicesAdmin::index');
    $routes->get('devices/(:segment)', 'Admin\DevicesAdmin::view/$1');
    $routes->post('devices/(:segment)/status', 'Admin\DevicesAdmin::updateStatus/$1');
    $routes->get('devices/stats', 'Admin\DevicesAdmin::stats');
    
    // =========================================================================
    // CONSENTS
    // =========================================================================
    $routes->get('consents', 'Admin\ConsentsAdmin::index');
    $routes->get('consents/(:num)/history', 'Admin\ConsentsAdmin::history/$1');
    $routes->get('consents/versions', 'Admin\ConsentsAdmin::versions');
    $routes->put('consents/versions', 'Admin\ConsentsAdmin::updateVersions');
    
    // =========================================================================
    // GDPR
    // =========================================================================
    $routes->get('gdpr/exports', 'Admin\GdprAdmin::exports');
    $routes->get('gdpr/deletions', 'Admin\GdprAdmin::deletions');
    $routes->post('gdpr/exports/(:num)/process', 'Admin\GdprAdmin::processExport/$1');
    $routes->post('gdpr/deletions/(:num)/process', 'Admin\GdprAdmin::processDeletion/$1');
    
    // =========================================================================
    // NOTIFICATIONS
    // =========================================================================
    $routes->get('notifications', 'Admin\NotificationsAdmin::index');
    $routes->post('notifications/send', 'Admin\NotificationsAdmin::send');
    $routes->get('notifications/stats', 'Admin\NotificationsAdmin::stats');
    
    // =========================================================================
    // API LOGS
    // =========================================================================
    $routes->get('api-logs', 'Admin\ApiLogs::getLogs');
    $routes->get('api-logs/(:num)', 'Admin\ApiLogs::view/$1');
    $routes->delete('api-logs/(:num)', 'Admin\ApiLogs::delete/$1');
    $routes->post('api-logs/purge', 'Admin\ApiLogs::purge');
    $routes->get('api-logs/export', 'Admin\ApiLogs::export');
    
    // =========================================================================
    // SECURITY LOGS
    // =========================================================================
    $routes->get('security-logs', 'Admin\SecurityLogsAdmin::index');
    $routes->get('security-logs/suspicious', 'Admin\SecurityLogsAdmin::suspicious');
    $routes->get('security-logs/export', 'Admin\SecurityLogsAdmin::export');
    
    // =========================================================================
    // ANALYTICS
    // =========================================================================
    $routes->get('analytics/dashboard', 'AnalyticsController::getAdminDashboard');
    $routes->get('analytics/property/(:num)', 'AnalyticsController::getPropertyStats/$1');
    $routes->get('analytics/agent/(:num)', 'AnalyticsController::getAgentPortfolioStats/$1');
    $routes->get('analytics/search-stats', 'AnalyticsController::getSearchStatistics');
    
    // =========================================================================
    // JWT TOKENS
    // =========================================================================
    $routes->get('tokens/stats', 'Admin\TokensAdmin::statistics');
    $routes->post('tokens/cleanup', 'Admin\TokensAdmin::cleanup');
    $routes->post('tokens/revoke-user/(:num)', 'Admin\TokensAdmin::revokeUserTokens/$1');
    
    // =========================================================================
    // SYSTEM
    // =========================================================================
    $routes->get('system/health', 'Admin\SystemAdmin::health');
    $routes->post('system/cache-clear', 'Admin\SystemAdmin::clearCache');
});

/*
 * ============================================================================
 * API v1 - SUPER ADMIN ENDPOINTS
 * ============================================================================
 */

$routes->group('api/v1/super-admin', ['namespace' => 'App\Controllers', 'filter' => 'jwt,jwt-super-admin'], function($routes) {
    $routes->post('users/(:num)/make-admin', 'Admin\UsersAdmin::makeAdmin/$1');
    $routes->post('users/(:num)/remove-admin', 'Admin\UsersAdmin::removeAdmin/$1');
    $routes->get('system/config', 'Admin\SystemAdmin::config');
    $routes->put('system/config', 'Admin\SystemAdmin::updateConfig');
});

/*
 * ============================================================================
 * INTERNAL ROUTES (IP kısıtlamalı)
 * ============================================================================
 */

// Cron Jobs - Sadece sunucu IP'sinden
$routes->group('cron', ['filter' => 'cron-auth'], function($routes) {
    $routes->get('run', 'Listings::cron');
    $routes->get('cleanup-tokens', 'CronController::cleanupTokens');
    $routes->get('cleanup-data', 'CronController::cleanupOldData');
    $routes->get('appointment-reminders', 'CronController::sendAppointmentReminders');
    $routes->get('search-followups', 'CronController::searchRequestFollowUps');
    $routes->get('daily-reports', 'CronController::generateDailyReports');
    $routes->get('update-indexes', 'CronController::updatePropertyIndexes');
    $routes->get('sync-external', 'CronController::syncExternalData');
});

// Webhooks - Signature verification ile
$routes->group('webhooks', ['filter' => 'webhook-auth'], function($routes) {
    $routes->post('fcm-delivery', 'WebhookController::fcmDeliveryStatus');
    $routes->post('email-delivery', 'WebhookController::emailDeliveryStatus');
    $routes->post('crm-sync', 'WebhookController::crmSync');
    $routes->post('property-updates', 'WebhookController::propertyUpdates');
});

/*
 * ============================================================================
 * Additional Routing
 * ============================================================================
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
