<?php

namespace App\Controllers\Api\V1;

use CodeIgniter\Controller;

/**
 * Health Controller
 * 
 * API sağlık kontrolü endpoint'i
 */
class HealthController extends Controller
{
    public function index()
    {
        $status = 'healthy';
        $checks = [];

        // Database check
        try {
            $db = \Config\Database::connect();
            $db->query('SELECT 1');
            $checks['database'] = 'ok';
        } catch (\Exception $e) {
            $checks['database'] = 'error';
            $status = 'degraded';
        }

        // Logs database check
        try {
            $logsDb = \Config\Database::connect('logs');
            $logsDb->query('SELECT 1');
            $checks['logs_database'] = 'ok';
        } catch (\Exception $e) {
            $checks['logs_database'] = 'error';
            $status = 'degraded';
        }

        // Cache check
        try {
            $cache = \Config\Services::cache();
            $cache->save('health_check', true, 10);
            $checks['cache'] = $cache->get('health_check') ? 'ok' : 'error';
        } catch (\Exception $e) {
            $checks['cache'] = 'error';
        }

        return $this->response->setJSON([
            'code' => 'success',
            'status' => $status,
            'version' => '2.0.0',
            'api' => 'v1',
            'timestamp' => date('Y-m-d H:i:s'),
            'checks' => $checks,
        ]);
    }
}
