<?php

// app/Services/EmailService.php - Güncellenmiş versiyon (sadece kod gönderme)

namespace App\Services;

use Config\Email as EmailConfig;

class EmailService
{
    protected $email;
    protected $config;

    public function __construct()
    {
        $this->config = new EmailConfig();
        $this->email = \Config\Services::email();
    }

    /**
     * SMTP ayarlarını yapılandır - Çoklu deneme
     */
    private function configureEmail($configType = 'default')
    {
        $configs = [
            // TLS olmadan deneme
            'no_tls' => [
                'protocol'    => 'smtp',
                'SMTPHost'    => 'smtp.satisahazir.com',
                'SMTPUser'    => 'no-reply@satisahazir.com',
                'SMTPPass'    => 'No_*123123',
                'SMTPPort'    => 587,
                'SMTPCrypto'  => '',  // TLS yok
                'SMTPTimeout' => 60,
                'mailType'    => 'html',
                'charset'     => 'UTF-8',
                'validate'    => true,
                'newline'     => "\r\n",
                'CRLF'        => "\r\n"
            ],
            // Port 25 deneme
            'port_25' => [
                'protocol'    => 'smtp',
                'SMTPHost'    => 'smtp.satisahazir.com',
                'SMTPUser'    => 'no-reply@satisahazir.com',
                'SMTPPass'    => 'No_*123123',
                'SMTPPort'    => 25,
                'SMTPCrypto'  => '',
                'SMTPTimeout' => 60,
                'mailType'    => 'html',
                'charset'     => 'UTF-8',
                'validate'    => true,
                'newline'     => "\r\n",
                'CRLF'        => "\r\n"
            ],
            // SSL Port 465 deneme
            'ssl_465' => [
                'protocol'    => 'smtp',
                'SMTPHost'    => 'smtp.satisahazir.com',
                'SMTPUser'    => 'no-reply@satisahazir.com',
                'SMTPPass'    => 'No_*123123',
                'SMTPPort'    => 465,
                'SMTPCrypto'  => 'ssl',
                'SMTPTimeout' => 60,
                'mailType'    => 'html',
                'charset'     => 'UTF-8',
                'validate'    => true,
                'newline'     => "\r\n",
                'CRLF'        => "\r\n"
            ],
            // Varsayılan TLS
            'default' => [
                'protocol'    => 'smtp',
                'SMTPHost'    => 'smtp.satisahazir.com',
                'SMTPUser'    => 'no-reply@satisahazir.com',
                'SMTPPass'    => 'No_*123123',
                'SMTPPort'    => 587,
                'SMTPCrypto'  => 'tls',
                'SMTPTimeout' => 60,
                'mailType'    => 'html',
                'charset'     => 'UTF-8',
                'validate'    => true,
                'newline'     => "\r\n",
                'CRLF'        => "\r\n"
            ]
        ];

        $config = $configs[$configType] ?? $configs['no_tls'];
        
        $this->email->initialize($config);
        
        log_message('info', "SMTP Konfigürasyonu [{$configType}]: Host={$config['SMTPHost']}, Port={$config['SMTPPort']}, Crypto={$config['SMTPCrypto']}");
        
        return $config;
    }

    /**
     * E-posta gönderme - Tüm konfigürasyonları dene
     */
    private function sendEmailWithFallback($to, $subject, $message, $fromEmail = 'no-reply@satisahazir.com', $fromName = 'SatışaHazır.com')
    {
        $configTypes = ['no_tls', 'port_25', 'ssl_465', 'default'];
        
        foreach ($configTypes as $configType) {
            try {
                log_message('info', "E-posta gönderimi deneniyor [{$configType}]: {$to}");
                
                // Yeni email instance oluştur
                $this->email = \Config\Services::email();
                $this->configureEmail($configType);

                $this->email->setFrom($fromEmail, $fromName);
                $this->email->setTo($to);
                $this->email->setSubject($subject);
                $this->email->setMessage($message);
                $this->email->setReplyTo('info@satisahazir.com', 'SatışaHazır Destek');
               

                if ($this->email->send()) {
                    log_message('info', "E-posta başarıyla gönderildi [{$configType}]: {$to}");
                    return [
                        'success' => true, 
                        'message' => "E-posta başarıyla gönderildi ({$configType})",
                        'config_used' => $configType
                    ];
                }
                
            } catch (\Exception $e) {
                log_message('error', "Konfigürasyon [{$configType}] başarısız: " . $e->getMessage());
                continue;
            }
            
            // Debug bilgisi
            $debugInfo = $this->email->printDebugger(['headers']);
            log_message('error', "Konfigürasyon [{$configType}] başarısız - Debug: " . $debugInfo);
        }
        
        // Hiçbiri çalışmadıysa
        return [
            'success' => false, 
            'message' => 'Tüm SMTP konfigürasyonları başarısız',
            'last_error' => $this->email->printDebugger(['headers'])
        ];
    }

    /**
     * E-posta doğrulama maili gönder - Sadece kod ile
     */
    public function sendVerificationEmail($to, $userName, $verificationCode)
    {
        try {
            $emailContent = $this->getVerificationEmailTemplate($userName, $verificationCode);

            $result = $this->sendEmailWithFallback(
                $to,
                'SatışaHazır.com E-posta Doğrulama Kodu',
                $emailContent
            );

            return $result['success'];

        } catch (\Exception $e) {
            log_message('error', "EmailService hatası: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Hoş geldin e-postası gönder - Sadece kod ile
     */
    public function sendWelcomeEmail($to, $userName, $verificationCode)
    {
        try {
            $emailContent = $this->getWelcomeEmailTemplate($userName, $verificationCode);

            $result = $this->sendEmailWithFallback(
                $to,
                'SatışaHazır.com\'a Hoş Geldiniz! - E-posta Doğrulama',
                $emailContent
            );

            return $result['success'];

        } catch (\Exception $e) {
            log_message('error', "Hoş geldin e-posta hatası: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Test e-postası gönder - Tüm konfigürasyonları dene
     */
    public function sendTestEmail($to = 'test@satisahazir.com')
    {
        try {
            $testMessage = '<h1>Test E-posta</h1><p>SMTP servisi çalışıyor! ✅</p><p>Gönderim zamanı: ' . date('Y-m-d H:i:s') . '</p>';
            
            $result = $this->sendEmailWithFallback(
                $to,
                'Test E-posta - SatışaHazır.com',
                $testMessage
            );

            return $result;

        } catch (\Exception $e) {
            log_message('error', "Test e-posta hatası: " . $e->getMessage());
            return ['success' => false, 'message' => 'Hata: ' . $e->getMessage()];
        }
    }

    /**
     * Basit SMTP bağlantı testi
     */
    public function testSmtpConnection()
    {
        $configs = [
            'no_tls_587' => ['host' => 'smtp.satisahazir.com', 'port' => 587],
            'port_25' => ['host' => 'smtp.satisahazir.com', 'port' => 25],
            'ssl_465' => ['host' => 'smtp.satisahazir.com', 'port' => 465],
        ];

        $results = [];
        
        foreach ($configs as $name => $config) {
            try {
                $socket = fsockopen($config['host'], $config['port'], $errno, $errstr, 10);
                
                if ($socket) {
                    $response = fgets($socket, 512);
                    fclose($socket);
                    $results[$name] = [
                        'success' => true,
                        'message' => "Bağlantı başarılı: {$response}"
                    ];
                } else {
                    $results[$name] = [
                        'success' => false,
                        'message' => "Bağlantı başarısız: {$errstr} ({$errno})"
                    ];
                }
                
            } catch (\Exception $e) {
                $results[$name] = [
                    'success' => false,
                    'message' => 'Hata: ' . $e->getMessage()
                ];
            }
        }
        
        return $results;
    }

    /**
     * E-posta doğrulama template'i - Güncellenmiş (sadece kod)
     */
    private function getVerificationEmailTemplate($userName, $verificationCode)
    {
        return '
        <!DOCTYPE html>
        <html lang="tr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>E-posta Doğrulama Kodu</title>
        </head>
        <body style="font-family: -apple-system, BlinkMacSystemFont, Arial, sans-serif; line-height: 1.6; margin: 0; padding: 20px; background-color: #f8f9fa;">
            <div style="max-width: 600px; margin: 0 auto; background: white; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                
                <!-- Header -->
                <div style="background: linear-gradient(135deg, #112d4f, #AF8C55); color: white; padding: 40px 30px; text-align: center;">
                    <div style="width: 80px; height: 80px; background: rgba(255,255,255,0.1); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; border: 2px solid rgba(255,255,255,0.2);">
                        <span style="font-size: 36px;">🏠</span>
                    </div>
                    <h1 style="margin: 0; font-size: 28px; font-weight: 700;">SatışaHazır.com</h1>
                    <p style="margin: 8px 0 0; font-size: 16px; opacity: 0.9;">E-posta Doğrulama Kodu</p>
                </div>
                
                <!-- Content -->
                <div style="padding: 40px 30px;">
                    <h2 style="color: #112d4f; margin: 0 0 16px; font-size: 24px; font-weight: 600;">Merhaba ' . htmlspecialchars($userName) . '! 👋</h2>
                    
                    <p style="color: #4a5568; margin: 0 0 24px; font-size: 16px; line-height: 1.6;">
                        SatışaHazır.com\'a hoş geldiniz! Hesabınızı aktive etmek için aşağıdaki 6 haneli doğrulama kodunu uygulamada girin.
                    </p>
                    
                    <!-- Verification Code Box -->
                    <div style="background: linear-gradient(135deg, #f7fafc, #edf2f7); border: 2px dashed #AF8C55; padding: 30px; text-align: center; margin: 30px 0; border-radius: 16px; position: relative;">
                        <div style="background: #AF8C55; color: white; padding: 8px 16px; border-radius: 20px; display: inline-block; margin-bottom: 16px; font-size: 14px; font-weight: 600;">
                            📧 Doğrulama Kodu
                        </div>
                        <div style="font-size: 42px; font-weight: 900; color: #112d4f; letter-spacing: 8px; margin: 16px 0; font-family: monospace; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                            ' . $verificationCode . '
                        </div>
                        <p style="color: #6b7280; margin: 16px 0 0; font-size: 14px;">
                            Bu kod <strong>24 saat</strong> geçerlidir
                        </p>
                    </div>
                    
                    <!-- Instructions -->
                    <div style="background: #f0f9ff; border-left: 4px solid #0ea5e9; padding: 20px; margin: 24px 0; border-radius: 8px;">
                        <h3 style="color: #0c4a6e; margin: 0 0 12px; font-size: 16px; font-weight: 600;">📱 Nasıl Kullanırım?</h3>
                        <ol style="color: #075985; margin: 0; padding-left: 20px; font-size: 14px; line-height: 1.6;">
                            <li>SatışaHazır mobil uygulamasını açın</li>
                            <li>E-posta doğrulama ekranında kodu girin</li>
                            <li>"Kodu Doğrula" butonuna tıklayın</li>
                        </ol>
                    </div>
                    
                    <!-- Security Note -->
                    <div style="background: #fef3c7; border: 1px solid #f59e0b; padding: 16px; margin: 24px 0; border-radius: 8px;">
                        <p style="color: #92400e; margin: 0; font-size: 14px; line-height: 1.5;">
                            <strong>🔒 Güvenlik:</strong> Bu kodu kimseyle paylaşmayın. SatışaHazır ekibi asla bu kodu sizden talep etmez.
                        </p>
                    </div>
                    
                    <p style="color: #6b7280; margin: 24px 0 0; font-size: 14px; line-height: 1.5;">
                        Kod çalışmıyor mu? Uygulamadaki "Yeni Kod Gönder" butonunu kullanarak yeni bir kod talep edebilirsiniz.
                    </p>
                </div>
                
                <!-- Footer -->
                <div style="background: #f8f9fa; padding: 24px 30px; text-align: center; border-top: 1px solid #e5e7eb;">
                    <p style="color: #6b7280; margin: 0 0 8px; font-size: 14px; font-weight: 600;">
                        © 2024 SatışaHazır.com
                    </p>
                    <p style="color: #9ca3af; margin: 0; font-size: 12px;">
                        Bu otomatik bir e-postadır, lütfen yanıtlamayın.
                    </p>
                </div>
            </div>
        </body>
        </html>';
    }

    /**
     * Hoş geldin e-posta template'i - Güncellenmiş (sadece kod)
     */
    private function getWelcomeEmailTemplate($userName, $verificationCode)
    {
        return '
        <!DOCTYPE html>
        <html lang="tr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Hoş Geldiniz - E-posta Doğrulama</title>
        </head>
        <body style="font-family: -apple-system, BlinkMacSystemFont, Arial, sans-serif; line-height: 1.6; margin: 0; padding: 20px; background-color: #f8f9fa;">
            <div style="max-width: 600px; margin: 0 auto; background: white; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                
                <!-- Header -->
                <div style="background: linear-gradient(135deg, #112d4f, #AF8C55); color: white; padding: 40px 30px; text-align: center;">
                    <div style="width: 100px; height: 100px; background: rgba(255,255,255,0.1); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; border: 2px solid rgba(255,255,255,0.2);">
                        <span style="font-size: 48px;">🎉</span>
                    </div>
                    <h1 style="margin: 0; font-size: 32px; font-weight: 700;">Hoş Geldiniz!</h1>
                    <p style="margin: 8px 0 0; font-size: 18px; opacity: 0.9;">SatışaHazır.com Ailesine Katıldınız</p>
                </div>
                
                <!-- Content -->
                <div style="padding: 40px 30px;">
                    <h2 style="color: #112d4f; margin: 0 0 16px; font-size: 24px; font-weight: 600;">Merhaba ' . htmlspecialchars($userName) . '! 🏠</h2>
                    
                    <p style="color: #4a5568; margin: 0 0 24px; font-size: 16px; line-height: 1.6;">
                        SatışaHazır.com\'a başarıyla kayıt oldunuz! Hesabınızı aktive etmek ve tüm özellikleri kullanabilmek için aşağıdaki doğrulama kodunu kullanın.
                    </p>
                    
                    <!-- Verification Code Box -->
                    <div style="background: linear-gradient(135deg, #f0f9ff, #e0f2fe); border: 3px solid #AF8C55; padding: 35px; text-align: center; margin: 30px 0; border-radius: 20px; box-shadow: 0 8px 25px rgba(175,140,85,0.15);">
                        <div style="background: #AF8C55; color: white; padding: 10px 20px; border-radius: 25px; display: inline-block; margin-bottom: 20px; font-size: 16px; font-weight: 700;">
                            🔑 E-posta Doğrulama Kodu
                        </div>
                        <div style="font-size: 48px; font-weight: 900; color: #112d4f; letter-spacing: 10px; margin: 20px 0; font-family: monospace; text-shadow: 0 3px 6px rgba(0,0,0,0.1); background: linear-gradient(45deg, #112d4f, #AF8C55); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                            ' . $verificationCode . '
                        </div>
                        <div style="background: rgba(175,140,85,0.1); padding: 12px 20px; border-radius: 12px; margin-top: 16px;">
                            <p style="color: #8B6914; margin: 0; font-size: 14px; font-weight: 600;">
                                ⏰ Bu kod 24 saat geçerlidir
                            </p>
                        </div>
                    </div>
                    
                    <!-- Steps -->
                    <div style="background: #f8fafc; border: 1px solid #e2e8f0; padding: 25px; margin: 24px 0; border-radius: 12px;">
                        <h3 style="color: #2d3748; margin: 0 0 16px; font-size: 18px; font-weight: 600;">📋 Hesabınızı Aktive Edin:</h3>
                        <div style="display: flex; flex-direction: column; gap: 12px;">
                            <div style="display: flex; align-items: center; padding: 8px 0;">
                                <div style="width: 24px; height: 24px; background: #AF8C55; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: bold; margin-right: 12px;">1</div>
                                <span style="color: #4a5568; font-size: 14px;">SatışaHazır uygulamasını açın</span>
                            </div>
                            <div style="display: flex; align-items: center; padding: 8px 0;">
                                <div style="width: 24px; height: 24px; background: #AF8C55; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: bold; margin-right: 12px;">2</div>
                                <span style="color: #4a5568; font-size: 14px;">E-posta doğrulama ekranında yukarıdaki kodu girin</span>
                            </div>
                            <div style="display: flex; align-items: center; padding: 8px 0;">
                                <div style="width: 24px; height: 24px; background: #AF8C55; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: bold; margin-right: 12px;">3</div>
                                <span style="color: #4a5568; font-size: 14px;">"Kodu Doğrula" butonuna tıklayın</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Features Preview -->
                    <div style="background: linear-gradient(135deg, #f7fafc, #edf2f7); padding: 25px; margin: 24px 0; border-radius: 12px; border: 1px solid #e2e8f0;">
                        <h3 style="color: #2d3748; margin: 0 0 16px; font-size: 18px; font-weight: 600;">🚀 SatışaHazır.com ile Neler Yapabilirsiniz?</h3>
                        <ul style="color: #4a5568; margin: 0; padding-left: 0; list-style: none; font-size: 14px;">
                            <li style="margin-bottom: 8px; display: flex; align-items: center;"><span style="color: #AF8C55; margin-right: 8px;">✅</span> Binlerce mülk ilanına anında erişim</li>
                            <li style="margin-bottom: 8px; display: flex; align-items: center;"><span style="color: #AF8C55; margin-right: 8px;">✅</span> Favori mülklerinizi kaydedin</li>
                            <li style="margin-bottom: 8px; display: flex; align-items: center;"><span style="color: #AF8C55; margin-right: 8px;">✅</span> Detaylı arama filtreleri</li>
                            <li style="margin-bottom: 8px; display: flex; align-items: center;"><span style="color: #AF8C55; margin-right: 8px;">✅</span> Mülk sahipleriyle doğrudan iletişim</li>
                            <li style="display: flex; align-items: center;"><span style="color: #AF8C55; margin-right: 8px;">✅</span> Size özel mülk önerileri</li>
                        </ul>
                    </div>
                    
                    <p style="color: #6b7280; margin: 24px 0 0; font-size: 14px; line-height: 1.5; text-align: center;">
                        Herhangi bir sorunuz var mı? Destek ekibimiz size yardımcı olmaktan mutluluk duyar.
                    </p>
                </div>
                
                <!-- Footer -->
                <div style="background: #112d4f; color: white; padding: 30px; text-align: center;">
                    <h3 style="margin: 0 0 12px; font-size: 20px; font-weight: 600;">🏠 SatışaHazır.com</h3>
                    <p style="margin: 0 0 16px; font-size: 14px; opacity: 0.8;">
                        Hayalinizdeki ev bir tık uzakta
                    </p>
                    <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <p style="margin: 0; font-size: 12px; opacity: 0.6;">
                            © 2024 SatışaHazır.com - Bu otomatik bir e-postadır, lütfen yanıtlamayın.
                        </p>
                    </div>
                </div>
            </div>
        </body>
        </html>';
    }
    
     /**
     * Şifre sıfırlama e-postası gönder
     */
    public function sendPasswordResetEmail($to, $userName, $resetCode)
    {
        try {
            $emailContent = $this->getPasswordResetEmailTemplate($userName, $resetCode);

            $result = $this->sendEmailWithFallback(
                $to,
                '🔒 Şifre Sıfırlama Kodu - SatışaHazır.com',
                $emailContent
            );

            return $result['success'];

        } catch (\Exception $e) {
            log_message('error', "Şifre sıfırlama e-posta hatası: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Şifre değiştirildi bildirim e-postası gönder
     */
    public function sendPasswordChangedNotificationEmail($to, $userName)
    {
        try {
            $emailContent = $this->getPasswordChangedEmailTemplate($userName);

            $result = $this->sendEmailWithFallback(
                $to,
                '✅ Şifreniz Değiştirildi - SatışaHazır.com',
                $emailContent
            );

            return $result['success'];

        } catch (\Exception $e) {
            log_message('error', "Şifre değiştirildi bildirim e-posta hatası: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Şifre sıfırlama e-posta template'i
     */
    private function getPasswordResetEmailTemplate($userName, $resetCode)
    {
        return '
        <!DOCTYPE html>
        <html lang="tr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Şifre Sıfırlama Kodu</title>
        </head>
        <body style="font-family: -apple-system, BlinkMacSystemFont, Arial, sans-serif; line-height: 1.6; margin: 0; padding: 20px; background-color: #f8f9fa;">
            <div style="max-width: 600px; margin: 0 auto; background: white; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                
                <!-- Header -->
                <div style="background: linear-gradient(135deg, #112d4f, #AF8C55); color: white; padding: 40px 30px; text-align: center;">
                    <div style="width: 80px; height: 80px; background: rgba(255,255,255,0.1); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; border: 2px solid rgba(255,255,255,0.2);">
                        <span style="font-size: 36px;">🔒</span>
                    </div>
                    <h1 style="margin: 0; font-size: 28px; font-weight: 700;">Şifre Sıfırlama</h1>
                    <p style="margin: 8px 0 0; font-size: 16px; opacity: 0.9;">SatışaHazır.com</p>
                </div>
                
                <!-- Content -->
                <div style="padding: 40px 30px;">
                    <h2 style="color: #112d4f; margin: 0 0 16px; font-size: 24px; font-weight: 600;">Merhaba ' . htmlspecialchars($userName) . '! 👋</h2>
                    
                    <p style="color: #4a5568; margin: 0 0 24px; font-size: 16px; line-height: 1.6;">
                        Hesabınız için şifre sıfırlama talebinde bulundunuz. Aşağıdaki 6 haneli kodu SatışaHazır uygulamasında girerek şifrenizi sıfırlayabilirsiniz.
                    </p>
                    
                    <!-- Reset Code Box -->
                    <div style="background: linear-gradient(135deg, #fff5f5, #fed7d7); border: 3px solid #e53e3e; padding: 35px; text-align: center; margin: 30px 0; border-radius: 20px; box-shadow: 0 8px 25px rgba(229,62,62,0.15);">
                        <div style="background: #e53e3e; color: white; padding: 10px 20px; border-radius: 25px; display: inline-block; margin-bottom: 20px; font-size: 16px; font-weight: 700;">
                            🔑 Şifre Sıfırlama Kodu
                        </div>
                        <div style="font-size: 48px; font-weight: 900; color: #c53030; letter-spacing: 10px; margin: 20px 0; font-family: monospace; text-shadow: 0 3px 6px rgba(0,0,0,0.1);">
                            ' . $resetCode . '
                        </div>
                        <div style="background: rgba(229,62,62,0.1); padding: 12px 20px; border-radius: 12px; margin-top: 16px;">
                            <p style="color: #c53030; margin: 0; font-size: 14px; font-weight: 600;">
                                ⏰ Bu kod 30 dakika geçerlidir
                            </p>
                        </div>
                    </div>
                    
                    <!-- Steps -->
                    <div style="background: #f8fafc; border: 1px solid #e2e8f0; padding: 25px; margin: 24px 0; border-radius: 12px;">
                        <h3 style="color: #2d3748; margin: 0 0 16px; font-size: 18px; font-weight: 600;">📋 Şifrenizi Sıfırlayın:</h3>
                        <div style="display: flex; flex-direction: column; gap: 12px;">
                            <div style="display: flex; align-items: center; padding: 8px 0;">
                                <div style="width: 24px; height: 24px; background: #e53e3e; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: bold; margin-right: 12px;">1</div>
                                <span style="color: #4a5568; font-size: 14px;">SatışaHazır uygulamasını açın</span>
                            </div>
                            <div style="display: flex; align-items: center; padding: 8px 0;">
                                <div style="width: 24px; height: 24px; background: #e53e3e; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: bold; margin-right: 12px;">2</div>
                                <span style="color: #4a5568; font-size: 14px;">Şifre sıfırlama ekranında yukarıdaki kodu girin</span>
                            </div>
                            <div style="display: flex; align-items: center; padding: 8px 0;">
                                <div style="width: 24px; height: 24px; background: #e53e3e; color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: bold; margin-right: 12px;">3</div>
                                <span style="color: #4a5568; font-size: 14px;">Yeni şifrenizi belirleyin</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Security Warning -->
                    <div style="background: #fef3c7; border: 1px solid #f59e0b; padding: 20px; margin: 24px 0; border-radius: 12px;">
                        <h3 style="color: #92400e; margin: 0 0 12px; font-size: 16px; font-weight: 600;">⚠️ Güvenlik Uyarısı:</h3>
                        <ul style="color: #92400e; margin: 0; padding-left: 20px; font-size: 14px; line-height: 1.6;">
                            <li>Bu kodu kimseyle paylaşmayın</li>
                            <li>Eğer şifre sıfırlama talebinde bulunmadıysanız bu e-postayı dikkate almayın</li>
                            <li>Kod 30 dakika sonra geçersiz olacaktır</li>
                        </ul>
                    </div>
                    
                    <p style="color: #6b7280; margin: 24px 0 0; font-size: 14px; line-height: 1.5; text-align: center;">
                        Sorularınız için bizimle iletişime geçebilirsiniz.
                    </p>
                </div>
                
                <!-- Footer -->
                <div style="background: #112d4f; color: white; padding: 30px; text-align: center;">
                    <h3 style="margin: 0 0 12px; font-size: 20px; font-weight: 600;">🏠 SatışaHazır.com</h3>
                    <p style="margin: 0 0 16px; font-size: 14px; opacity: 0.8;">
                        Güvenli gayrimenkul platformu
                    </p>
                    <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <p style="margin: 0; font-size: 12px; opacity: 0.6;">
                            © 2024 SatışaHazır.com - Bu otomatik bir e-postadır, lütfen yanıtlamayın.
                        </p>
                    </div>
                </div>
            </div>
        </body>
        </html>';
    }

   /**
     * Şifre değiştirildi bildirim e-posta template'i
     */
    private function getPasswordChangedEmailTemplate($userName)
    {
        return '
        <!DOCTYPE html>
        <html lang="tr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Şifre Değiştirildi</title>
        </head>
        <body style="font-family: -apple-system, BlinkMacSystemFont, Arial, sans-serif; line-height: 1.6; margin: 0; padding: 20px; background-color: #f8f9fa;">
            <div style="max-width: 600px; margin: 0 auto; background: white; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                
                <!-- Header -->
                <div style="background: linear-gradient(135deg, #22c55e, #16a34a); color: white; padding: 40px 30px; text-align: center;">
                    <div style="width: 80px; height: 80px; background: rgba(255,255,255,0.1); border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; border: 2px solid rgba(255,255,255,0.2);">
                        <span style="font-size: 36px;">✅</span>
                    </div>
                    <h1 style="margin: 0; font-size: 28px; font-weight: 700;">Şifre Değiştirildi</h1>
                    <p style="margin: 8px 0 0; font-size: 16px; opacity: 0.9;">SatışaHazır.com</p>
                </div>
                
                <!-- Content -->
                <div style="padding: 40px 30px;">
                    <h2 style="color: #112d4f; margin: 0 0 16px; font-size: 24px; font-weight: 600;">Merhaba ' . htmlspecialchars($userName) . '! 👋</h2>
                    
                    <!-- Success Message -->
                    <div style="background: linear-gradient(135deg, #f0fdf4, #dcfce7); border: 3px solid #22c55e; padding: 35px; text-align: center; margin: 30px 0; border-radius: 20px; box-shadow: 0 8px 25px rgba(34,197,94,0.15);">
                        <div style="background: #22c55e; color: white; padding: 10px 20px; border-radius: 25px; display: inline-block; margin-bottom: 20px; font-size: 16px; font-weight: 700;">
                            🎉 Başarılı!
                        </div>
                        <h3 style="font-size: 24px; font-weight: 900; color: #16a34a; margin: 20px 0; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                            Şifreniz Değiştirildi
                        </h3>
                        <div style="background: rgba(34,197,94,0.1); padding: 12px 20px; border-radius: 12px; margin-top: 16px;">
                            <p style="color: #16a34a; margin: 0; font-size: 14px; font-weight: 600;">
                                📅 Değişiklik Zamanı: ' . date('d.m.Y H:i') . '
                            </p>
                        </div>
                    </div>
                    
                    <p style="color: #4a5568; margin: 0 0 24px; font-size: 16px; line-height: 1.6;">
                        Hesabınızın şifresi başarıyla değiştirildi. Artık yeni şifrenizle SatışaHazır uygulamasına giriş yapabilirsiniz.
                    </p>
                    
                    <!-- Security Info -->
                    <div style="background: #fef3c7; border: 1px solid #f59e0b; padding: 20px; margin: 24px 0; border-radius: 12px;">
                        <h3 style="color: #92400e; margin: 0 0 12px; font-size: 16px; font-weight: 600;">🔒 Güvenlik Bilgisi:</h3>
                        <p style="color: #92400e; margin: 0; font-size: 14px; line-height: 1.6;">
                            Eğer bu değişikliği siz yapmadıysanız, lütfen derhal bizimle iletişime geçin ve hesabınızın güvenliğini sağlayın.
                        </p>
                    </div>
                    
                    <!-- Security Tips -->
                    <div style="background: #f0f9ff; border: 1px solid #0ea5e9; padding: 20px; margin: 24px 0; border-radius: 12px;">
                        <h3 style="color: #0c4a6e; margin: 0 0 12px; font-size: 16px; font-weight: 600;">💡 Güvenlik İpuçları:</h3>
                        <ul style="color: #075985; margin: 0; padding-left: 20px; font-size: 14px; line-height: 1.6;">
                            <li>Şifrenizi kimseyle paylaşmayın</li>
                            <li>Güçlü ve benzersiz şifreler kullanın</li>
                            <li>Şifrenizi düzenli olarak değiştirin</li>
                            <li>Şüpheli aktiviteleri derhal bildirin</li>
                        </ul>
                    </div>
                    
                    <p style="color: #6b7280; margin: 24px 0 0; font-size: 14px; line-height: 1.5; text-align: center;">
                        Herhangi bir sorunuz var mı? Destek ekibimiz size yardımcı olmaktan mutluluk duyar.
                    </p>
                </div>
                
                <!-- Footer -->
                <div style="background: #112d4f; color: white; padding: 30px; text-align: center;">
                    <h3 style="margin: 0 0 12px; font-size: 20px; font-weight: 600;">🏠 SatışaHazır.com</h3>
                    <p style="margin: 0 0 16px; font-size: 14px; opacity: 0.8;">
                        Güvenli gayrimenkul platformu
                    </p>
                    <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid rgba(255,255,255,0.1);">
                        <p style="margin: 0; font-size: 12px; opacity: 0.6;">
                            © 2024 SatışaHazır.com - Bu otomatik bir e-postadır, lütfen yanıtlamayın.
                        </p>
                    </div>
                </div>
            </div>
        </body>
        </html>';
    }

    /**
     * Şifre sıfırlama e-postası test metodu
     */
    public function testPasswordResetEmail($to = 'test@satisahazir.com')
    {
        try {
            $testUserName = 'Test Kullanıcı';
            $testResetCode = '123123';
            
            // Şifre sıfırlama e-postası testi
            $resetResult = $this->sendPasswordResetEmail($to, $testUserName, $testResetCode);
            
            // Şifre değiştirildi e-postası testi
            $changedResult = $this->sendPasswordChangedNotificationEmail($to, $testUserName);
            
            return [
                'success' => true,
                'message' => 'Şifre sıfırlama e-posta testleri tamamlandı',
                'results' => [
                    'password_reset_email' => $resetResult ? 'Başarılı' : 'Başarısız',
                    'password_changed_email' => $changedResult ? 'Başarılı' : 'Başarısız'
                ],
                'test_data' => [
                    'email' => $to,
                    'name' => $testUserName,
                    'reset_code' => $testResetCode,
                    'timestamp' => date('Y-m-d H:i:s')
                ]
            ];
            
        } catch (\Exception $e) {
            return [
                'success' => false,
                'message' => 'Şifre sıfırlama e-posta test hatası: ' . $e->getMessage()
            ];
        }
    }
}
   
   
   
