<?= $this->extend('admin/layout/default') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">API Log Detayı #<?= $log['id'] ?></h3>
                    <div class="card-tools">
                        <a href="<?= site_url('admin/api-logs') ?>" class="btn btn-sm btn-default">
                            <i class="fas fa-arrow-left"></i> Geri Dön
                        </a>
                        <a href="<?= site_url('admin/api-logs/delete/' . $log['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu kaydı silmek istediğinize emin misiniz?')">
                            <i class="fas fa-trash"></i> Sil
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 30%">ID</th>
                                    <td><?= $log['id'] ?></td>
                                </tr>
                                <tr>
                                    <th>Tarih</th>
                                    <td><?= $log['request_time'] ?></td>
                                </tr>
                                <tr>
                                    <th>URL</th>
                                    <td><?= $log['uri'] ?></td>
                                </tr>
                                <tr>
                                    <th>Method</th>
                                    <td><span class="badge badge-info"><?= $log['method'] ?></span></td>
                                </tr>
                                <tr>
                                    <th>IP Adresi</th>
                                    <td><?= $log['ip_address'] ?></td>
                                </tr>
                                <tr>
                                    <th>Durum Kodu</th>
                                    <td>
                                        <?php 
                                        $class = 'success';
                                        if ($log['response_code'] >= 400 && $log['response_code'] < 500) {
                                            $class = 'warning';
                                        } else if ($log['response_code'] >= 500) {
                                            $class = 'danger';
                                        }
                                        ?>
                                        <span class="badge badge-<?= $class ?>"><?= $log['response_code'] ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Çalışma Süresi</th>
                                    <td><?= number_format($log['execution_time'], 3) ?> saniye</td>
                                </tr>
                                <tr>
                                    <th>Kullanıcı ID</th>
                                    <td>
                                        <?php if (!empty($log['user_id'])): ?>
                                            <a href="<?= site_url('admin/users/view/' . $log['user_id']) ?>">
                                                <?= $log['user_id'] ?>
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">Misafir</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Kullanıcı Aracısı</th>
                                    <td><?= $log['user_agent'] ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <!-- Cihaz Bilgileri kartı -->
                            <?php if (!empty($log['device_info'])): ?>
                            <div class="card card-outline card-info">
                                <div class="card-header">
                                    <h3 class="card-title">Cihaz Bilgileri</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <pre class="device-info"><?= $log['device_info_formatted'] ?? $log['device_info'] ?></pre>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <!-- İstek ve Yanıt Bilgileri için tabbed kartlar -->
                            <div class="card card-primary card-outline card-tabs">
                                <div class="card-header p-0 pt-1 border-bottom-0">
                                    <ul class="nav nav-tabs" id="log-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" id="tab-headers" data-toggle="pill" href="#headers" role="tab" aria-controls="headers" aria-selected="true">İstek Başlıkları</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="tab-request" data-toggle="pill" href="#request" role="tab" aria-controls="request" aria-selected="false">İstek Gövdesi</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="tab-response" data-toggle="pill" href="#response" role="tab" aria-controls="response" aria-selected="false">Yanıt Gövdesi</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-body">
                                    <div class="tab-content" id="log-tabs-content">
                                        <div class="tab-pane fade show active" id="headers" role="tabpanel" aria-labelledby="tab-headers">
                                            <pre class="request-headers"><?= $log['request_headers_formatted'] ?? $log['request_headers'] ?></pre>
                                        </div>
                                        <div class="tab-pane fade" id="request" role="tabpanel" aria-labelledby="tab-request">
                                            <pre class="request-body"><?= $log['request_body_formatted'] ?? $log['request_body'] ?></pre>
                                        </div>
                                        <div class="tab-pane fade" id="response" role="tabpanel" aria-labelledby="tab-response">
                                            <pre class="response-body"><?= $log['response_body_formatted'] ?? $log['response_body'] ?></pre>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('css') ?>
<style>
    pre {
        white-space: pre-wrap;
        word-wrap: break-word;
        max-height: 500px;
        overflow-y: auto;
        background-color: #f8f9fa;
        padding: 10px;
        border-radius: 5px;
    }
    
    .json-key {
        color: #0066cc;
    }
    
    .json-string {
        color: #008800;
    }
    
    .json-number {
        color: #aa0000;
    }
    
    .json-boolean {
        color: #aa0000;
        font-weight: bold;
    }
    
    .json-null {
        color: #aa0000;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script>
$(function() {
    // JSON formatını güzelleştirme fonksiyonu
    function syntaxHighlight(json) {
        if (typeof json != 'string') {
            json = JSON.stringify(json, undefined, 2);
        }
        json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
        return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function (match) {
            var cls = 'json-number';
            if (/^"/.test(match)) {
                if (/:$/.test(match)) {
                    cls = 'json-key';
                } else {
                    cls = 'json-string';
                }
            } else if (/true|false/.test(match)) {
                cls = 'json-boolean';
            } else if (/null/.test(match)) {
                cls = 'json-null';
            }
            return '<span class="' + cls + '">' + match + '</span>';
        });
    }
    
    // JSON metinlerini güzelleştir
    try {
        $('.request-headers').each(function() {
            let text = $(this).text();
            if (text) {
                let json = JSON.parse(text);
                $(this).html(syntaxHighlight(json));
            }
        });
        
        $('.request-body').each(function() {
            let text = $(this).text();
            if (text) {
                try {
                    let json = JSON.parse(text);
                    $(this).html(syntaxHighlight(json));
                } catch (e) {
                    // JSON değilse normal bırak
                }
            }
        });
        
        $('.response-body').each(function() {
            let text = $(this).text();
            if (text) {
                try {
                    let json = JSON.parse(text);
                    $(this).html(syntaxHighlight(json));
                } catch (e) {
                    // JSON değilse normal bırak
                }
            }
        });
        
        $('.device-info').each(function() {
            let text = $(this).text();
            if (text) {
                try {
                    let json = JSON.parse(text);
                    $(this).html(syntaxHighlight(json));
                } catch (e) {
                    // JSON değilse normal bırak
                }
            }
        });
    } catch (e) {
        console.error("JSON işleme hatası", e);
    }
});
</script>
<?= $this->endSection() ?>