<?php

namespace App\Models;

use CodeIgniter\Model;

class FieldModel extends Model
{
    protected $table      = 'option';
    protected $primaryKey = 'id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = [];

    // Custom vars

    protected $orderBy = 'order ASC';

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = true;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function findAll($limit = 0, $offset = 0)
    {
        $fields_table = 'option_lang ';

        $this->select('*');
        $this->join($fields_table, $this->table.'.id = '.$fields_table.'.option_id');
        $this->orderBy($this->table.'.order', 'ASC');

        $results = parent::findAll($limit, $offset);
        
        return $results;
    }

    public function get_pagination($limit, $offset, $where = array(), $user_check = FALSE, $user_id=NULL, $show_other_agents_litings = FALSE)
    {
        $fields_table = 'option_lang';

        $results = $this->findAll($limit, $offset);
        
        return $results;
    }









}